# Email OTP Configuration Guide

## Production Email Setup

To enable actual email sending for admin OTP login, follow these steps:

### 1. Gmail App Password Setup

1. Go to your Google Account settings
2. Navigate to Security → 2-Step Verification
3. Scroll down to "App passwords"
4. Generate a new app password for "Mail"
5. Copy the 16-character password

### 2. Environment Variables

Add these environment variables to your `.env` file:

```env
EMAIL_USER=edumetrixuk@gmail.com
EMAIL_PASSWORD=your_16_character_app_password_here
```

### 3. Current Demo Mode

Currently running in demo mode:
- OTP is displayed in server console
- No actual emails are sent
- Perfect for testing and development

### 4. Production Deployment

When deploying to production:
1. Set the EMAIL_PASSWORD environment variable
2. OTP will be sent via Gmail automatically
3. Remove console.log statements for security

### 5. Security Notes

- Only `edumetrixuk@gmail.com` can receive admin OTPs
- OTPs expire after 5 minutes
- Maximum 3 verification attempts per OTP
- Invalid email addresses are rejected

### 6. Testing

Test the system:
1. Visit `/admin` login page
2. Click "Send OTP"
3. Check server console for OTP in demo mode
4. Enter the 6-digit code to login

## Troubleshooting

- **Gmail login error**: Enable 2FA and use app password
- **OTP not received**: Check spam folder in production
- **Invalid email**: Only `edumetrixuk@gmail.com` is authorized