const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');
const User = require('./models/admin/User');
require('dotenv').config();

async function generateDevToken() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });

    // Find admin user
    const adminUser = await User.findOne({ username: 'admin@edumetrix.uk' });
    if (!adminUser) {
      console.error('Admin user not found. Please run: node create-admin.js');
      process.exit(1);
    }

    // Generate a valid JWT token
    const token = jwt.sign(
      { 
        userId: adminUser._id, 
        userType: adminUser.userType 
      },
      process.env.JWT_SECRET || 'your-secret-key',
      { expiresIn: '30d' }
    );

    console.log('\n=== Development Login Fix ===\n');
    console.log('Valid JWT Token generated for admin user:');
    console.log(token);
    console.log('\nTo fix the authentication issue:');
    console.log('1. Open browser developer console (F12)');
    console.log('2. Run: localStorage.setItem("token", "' + token + '")');
    console.log('3. Refresh the page');
    console.log('\nAlternatively, login with:');
    console.log('Username: admin@edumetrix.uk');
    console.log('Password: admin123');
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

generateDevToken();