// routes/common.js
import express from 'express';
import User from '../../models/admin/User.js';

const router = express.Router();

// Public: fetch admin details for chat
router.get('/admin-detail', async (req, res) => {
  try {
    const admin = await User.findOne({
      userType: 'admin',
      isActive: true,
      isDeleted: false
    }).select('-password');

    if (!admin) {
      return res.status(404).json({ message: 'Admin not found' });
    }

    res.json({ admin });
  } catch (err) {
    console.error('Error fetching admin:', err);
    res.status(500).json({ message: 'Server error fetching admin' });
  }
});

export default router;
