# EduMetrix Invoice Format - Sample & Specification

## Invoice Layout Design

```
┌─────────────────────────────────────────────────────────────────────────────┐
│                                                                             │
│  ┌────┐   EDUMETRIX UK                                    INVOICE          │
│  │ 🎓 │   Educational Excellence                                           │
│  └────┘   Online Tutoring Services                        #INV-2025-001    │
│                                                            Date: Jan 25, 2025│
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  COMPANY DETAILS                          BILL TO                          │
│  ─────────────────                        ────────                         │
│  EduMetrix UK                             Student Name: Ahmed Al Mansouri  │
│  123 Education Street                     Parent: Mr. Mohammed Al Mansouri │
│  London, EC1A 1BB                         Email: ahmed.almansouri@email.com│
│  United Kingdom                           Phone: +971 50 123 4567          │
│  Phone: +44 20 1234 5678                  Country: UAE                     │
│  Email: contact@edumetrix.uk              Class/Grade: Grade 10            │
│  Website: www.edumetrix.uk                Curriculum: British (IGCSE)      │
│  Reg No: UK12345678                                                        │
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  INVOICE FOR: January 2025                                                 │
│  Due Date: February 5, 2025                                                │
│  Payment Status: Pending                                                   │
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  CLASS DETAILS - SUBJECT WISE BREAKDOWN                                    │
│  ────────────────────────────────────────────────────────────────────      │
│                                                                             │
│  ┌───────────────────────────────────────────────────────────────────────┐ │
│  │ Subject        │ Classes │ Total Hours │ Rate/Hour │ Amount          │ │
│  ├───────────────────────────────────────────────────────────────────────┤ │
│  │ Mathematics    │    8    │    8.0 hrs  │ AED 50/hr │ AED 400.00      │ │
│  │ Physics        │    6    │    6.0 hrs  │ AED 50/hr │ AED 300.00      │ │
│  │ Chemistry      │    4    │    4.0 hrs  │ AED 50/hr │ AED 200.00      │ │
│  │ English        │    6    │    6.0 hrs  │ AED 50/hr │ AED 300.00      │ │
│  └───────────────────────────────────────────────────────────────────────┘ │
│                                                                             │
│  INVOICE SUMMARY                                                           │
│  ────────────────────────────────────────────────────────────────────      │
│                                                                             │
│                                          Subtotal:        AED 1,200.00     │
│                                          Discount (10%): -AED   120.00     │
│                                          ─────────────────────────────     │
│                                          TOTAL AMOUNT:     AED 1,080.00     │
│                                                                             │
│                                          Currency: AED (United Arab Emirates│
│                                                         Dirham)             │
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  PAYMENT INFORMATION                                                       │
│  ─────────────────────────────────────────────────────────────────────     │
│                                                                             │
│  Bank Transfer Details:                                                    │
│  ┌─────────────────────────────────────────────────────────────────────┐  │
│  │ Account Name:     EduMetrix Education Services Ltd                  │  │
│  │ Account Number:   12345678                                          │  │
│  │ Bank Name:        HSBC UK                                           │  │
│  │ Sort Code:        12-34-56                                          │  │
│  │ SWIFT/BIC:        HBUKGB4B                                          │  │
│  │ Branch:           London Central Branch                             │  │
│  │ Country:          United Kingdom                                    │  │
│  │ Currency:         GBP, USD, AED (Multi-currency accepted)           │  │
│  └─────────────────────────────────────────────────────────────────────┘  │
│                                                                             │
│  Alternative Payment Options:                                              │
│  ┌─────────────────────────────────────────────────────────────────────┐  │
│  │ 💳 Online Payment Link:                                             │  │
│  │    https://pay.edumetrix.uk/invoice/INV-2025-001                    │  │
│  │                                                                      │  │
│  │    Accepted: Credit/Debit Cards, PayPal, Stripe                     │  │
│  └─────────────────────────────────────────────────────────────────────┘  │
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  PAYMENT TERMS & CONDITIONS                                                │
│  ────────────────────────────────────────────────────────────────────      │
│                                                                             │
│  1. Payment Due Date: All invoices must be paid by the 5th of the month   │
│     for which classes are scheduled.                                       │
│                                                                             │
│  2. Advance Payment: This is an advance invoice for the upcoming month.    │
│     Payment must be received before classes commence.                      │
│                                                                             │
│  3. Late Payment: A late fee of 5% will be applied to invoices paid after │
│     the due date. Classes may be suspended until payment is received.      │
│                                                                             │
│  4. Payment Methods: We accept bank transfers, credit/debit cards, PayPal, │
│     and other online payment methods via our payment link.                 │
│                                                                             │
│  5. Payment Confirmation: Please email your payment receipt to             │
│     payments@edumetrix.uk immediately after making payment.                │
│                                                                             │
│  6. Refund Policy: Refunds are processed only for classes cancelled by     │
│     EduMetrix with 24 hours notice. Student cancellations are not eligible │
│     for refunds unless made 48 hours in advance.                           │
│                                                                             │
│  7. Rescheduling: Classes can be rescheduled up to 6 hours before the      │
│     scheduled time. Last-minute changes may not be accommodated.           │
│                                                                             │
│  8. Currency: All amounts are listed in the student's preferred currency.  │
│     Exchange rates are locked at the time of invoice generation.           │
│                                                                             │
│  9. Tax: Prices include all applicable taxes unless otherwise stated.      │
│                                                                             │
│  10. Disputes: Any billing disputes must be raised within 7 days of        │
│      invoice receipt.                                                      │
│                                                                             │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│                     🎓 EDUMETRIX UK - EDUCATIONAL EXCELLENCE               │
│            Personalised 1-on-1 Online Tutoring for every student           │
│                                                                             │
│              This is a computer-generated invoice and does not require     │
│                          a physical signature                               │
│                                                                             │
└─────────────────────────────────────────────────────────────────────────────┘
```

---

## Key Features Included in This Invoice Format:

### 1. **Header Section**
- ✅ Company Logo (EduMetrix branding)
- ✅ Invoice Number (auto-generated)
- ✅ Invoice Date
- ✅ Company Name & Tagline

### 2. **Company & Student Details (Side by Side)**
- ✅ Company full address, phone, email, website, registration number
- ✅ Student name, parent name
- ✅ Student email, phone, country
- ✅ Student class/grade and curriculum

### 3. **Invoice Period & Status**
- ✅ Month/Year for which invoice is generated
- ✅ Due date
- ✅ Payment status

### 4. **Class Details - Two Levels**

**Level 1: Subject-wise Summary**
- Subject name
- Number of classes for that subject
- Total hours (calculated from class durations)
- Hourly rate (from student profile)
- Amount per subject (hours × rate)

**Level 2: Detailed Class Schedule**
- Date of each class
- Subject name
- Teacher name
- Duration (in minutes)
- Amount for that class

### 5. **Financial Calculations**
- ✅ **Subtotal**: Automatic calculation from all classes (hours × hourly rate)
- ✅ **Discount**: Configurable percentage or fixed amount
- ✅ **Total Amount**: Subtotal minus discount
- ✅ **Currency**: From student profile (AED, GBP, USD, etc.)

### 6. **Payment Information**

**Bank Account Details:**
- Account Name
- Account Number
- Bank Name
- Sort Code / IFSC Code / SWIFT Code (based on country)
- Branch Name
- Country
- Supported Currencies

**Payment Link:**
- Online payment URL (optional)
- Accepted payment methods

### 7. **Payment Terms & Conditions**
- 10 comprehensive terms covering:
  - Payment due dates
  - Late payment fees
  - Refund policy
  - Rescheduling policy
  - Currency information
  - Dispute resolution

### 8. **Notes Section**
- Custom notes
- Discount information
- Special offers
- Upcoming invoice schedule

### 9. **Contact Information**
- Multiple contact methods (email, phone, WhatsApp, website)
- Support hours
- Multiple country phone numbers

### 10. **Footer**
- Company branding
- Professional disclaimer

---

## Data Flow & Auto-Calculation Logic:

```
1. SELECT STUDENT → Fetch student profile data:
   - Student Name, Parent Name, Email, Phone
   - Country, Currency
   - Hourly Rate
   - Class/Grade, Curriculum

2. SELECT MONTH → Fetch all scheduled classes for that month:
   - Class Date, Subject, Teacher Name
   - Duration (in minutes)
   - Convert duration to hours: duration / 60

3. CALCULATE PER CLASS:
   - Hours = Duration / 60
   - Amount = Hours × Student Hourly Rate

4. GROUP BY SUBJECT:
   - Count number of classes per subject
   - Sum total hours per subject
   - Sum total amount per subject

5. CALCULATE TOTALS:
   - Subtotal = Sum of all class amounts
   - Discount = User-entered percentage or fixed amount
   - Total Amount = Subtotal - Discount

6. FETCH BANK DETAILS:
   - From admin-configured bank accounts
   - Show appropriate bank based on currency/country

7. APPLY COMPANY BRANDING:
   - Company name, address, phone, email, website
   - From admin settings or defaults

8. APPLY PAYMENT TERMS:
   - Pre-configured terms or admin-customizable
```

---

## Invoice Actions Available:

1. **Preview Invoice** - View complete invoice before generating
2. **Edit Invoice** - Modify discount, payment terms, bank account, notes
3. **Download PDF** - Generate professional PDF with all details
4. **Send to Student** - Email invoice to student's registered email
5. **Mark as Paid** - Update payment status with payment date
6. **Void/Cancel** - Cancel incorrect invoices

---

## Questions for You:

1. **Discount**: Should it be percentage-based, fixed amount, or both options?
2. **Multiple Bank Accounts**: Can admin select which bank account to show on each invoice?
3. **Payment Link**: Should this be auto-generated or manually entered?
4. **Logo**: Should we use an emoji (🎓) or allow upload of actual company logo image?
5. **Tax/VAT**: Should we add tax calculation option? (Currently not included)
6. **Currency Conversion**: If student is in UAE but pays in GBP, show both amounts?
7. **Multiple Languages**: Should invoice be available in Arabic/other languages?
8. **Custom Terms**: Should admin be able to customize payment terms per invoice or use global terms?

Please review this format and let me know:
- ✅ What you like
- ❌ What needs to be changed
- ➕ What else should be added

Once you approve this format, I'll proceed with the full implementation!
