// Clear Chat History Script
// Run this in browser console to manually clear all chat data

function clearAllChatHistory() {
  
  // Clear localStorage items related to chats
  const keysToRemove = [];
  
  // Find all chat-related keys
  for (let i = 0; i < localStorage.length; i++) {
    const key = localStorage.key(i);
    if (key && (key.includes('dev-chats') || key.startsWith('dev-messages-'))) {
      keysToRemove.push(key);
    }
  }
  
  // Remove all chat-related keys
  keysToRemove.forEach(key => {
    localStorage.removeItem(key);
  });
  
  
  return {
    cleared: keysToRemove.length,
    keys: keysToRemove
  };
}

// Auto-run the function
clearAllChatHistory();