# Subdomain Deployment Configuration

## Architecture: Modified Monolith

### Backend Configuration (api.edumetrix.uk)
```javascript
// server.js modifications
const corsOptions = {
  origin: [
    'https://kaaryasthan.edumetrix.uk',
    'https://teacher.edumetrix.uk',
    'https://student.edumetrix.uk',
    // Development origins
    'http://localhost:3001',
    'http://localhost:3002',
    'http://localhost:3003'
  ],
  credentials: true
};
```

### Frontend Build Scripts
```bash
# Build admin portal
REACT_APP_PORTAL_TYPE=admin REACT_APP_API_URL=https://api.edumetrix.uk npm run build
mv build admin-build

# Build teacher portal  
REACT_APP_PORTAL_TYPE=teacher REACT_APP_API_URL=https://api.edumetrix.uk npm run build
mv build teacher-build

# Build student portal
REACT_APP_PORTAL_TYPE=student REACT_APP_API_URL=https://api.edumetrix.uk npm run build
mv build student-build
```

### Nginx Configuration
```nginx
# API Backend
server {
    server_name api.edumetrix.uk;
    location / {
        proxy_pass https://backend.edumetrix.uk;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
    }
}

# Admin Portal (Kaaryasthan)
server {
    server_name kaaryasthan.edumetrix.uk;
    root /var/www/admin-build;
    
    location / {
        try_files $uri /index.html;
    }
}

# Teacher Portal
server {
    server_name teacher.edumetrix.uk;
    root /var/www/teacher-build;
    
    location / {
        try_files $uri /index.html;
    }
}

# Student Portal
server {
    server_name student.edumetrix.uk;
    root /var/www/student-build;
    
    location / {
        try_files $uri /index.html;
    }
}
```

## Benefits of This Approach

1. **Shared Business Logic**: All business rules remain in one place
2. **Single Database**: Maintains data consistency
3. **Easier Maintenance**: One backend to update and monitor
4. **Cost Effective**: Single backend server, static frontend hosting
5. **Scalability**: Can add load balancing or migrate to microservices later
6. **Security**: Each portal is isolated at the frontend level

## Future Migration Path

If you need microservices later:
1. Start by extracting authentication service
2. Then separate student service (most isolated)
3. Teacher service next
4. Admin service last (most interconnected)

## Deployment Steps

1. Set up subdomains in DNS
2. Deploy backend to api.edumetrix.uk
3. Build three frontend versions
4. Deploy each frontend to respective subdomain
5. Configure SSL certificates for all subdomains
6. Update CORS settings in backend