import mongoose from 'mongoose';

const notificationSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    required: true,
    index: true
  },
  userType: {
    type: String,
    enum: ['admin', 'teacher', 'student'],
    required: true
  },
  type: {
    type: String,
    enum: [
      'class_scheduled',
      'class_cancelled',
      'class_rescheduled',
      'class_updated',
      'quicktest_assigned',
      'quicktest_submitted',
      'quicktest_graded',
      'homework_assigned',
      'homework_submitted',
      'homework_graded',
      'assignment_due',
      'assignment_submitted',
      'exam_scheduled',
      'exam_result',
      'invoice_generated',
      'invoice_due',
      'payment_received',
      'report_available',
      'message_received',
      'trial_request',
      'reschedule_request',
      'reschedule_approved',
      'reschedule_rejected',
      'general'
    ],
    required: true
  },
  title: {
    type: String,
    required: true
  },
  message: {
    type: String,
    required: true
  },
  relatedId: {
    type: mongoose.Schema.Types.ObjectId,
    default: null
  },
  relatedModel: {
    type: String,
    enum: ['Class', 'Assignment', 'Exam', 'QuickTest', 'Homework', 'Invoice', 'Message', 'TrialRequest', 'RescheduleRequest', 'Report', null],
    default: null
  },
  isRead: {
    type: Boolean,
    default: false
  },
  priority: {
    type: String,
    enum: ['low', 'medium', 'high'],
    default: 'medium'
  },
  actionUrl: {
    type: String,
    default: null
  }
}, {
  timestamps: true
});

// Index for efficient queries
notificationSchema.index({ userId: 1, isRead: 1, createdAt: -1 });
notificationSchema.index({ userType: 1, createdAt: -1 });

export default mongoose.model('Notification', notificationSchema);