import mongoose from 'mongoose';

const teacherSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  name: {
    type: String,
    required: true
  },
  phoneNumber: {
    countryCode: {
      type: String,
      required: true
    },
    number: {
      type: String,
      required: true
    }
  },
  email: {
    type: String,
    required: true
  },
  bio: {
    type: String,
  },
  profilePicture: {
    type: String,
    default: null
  },
  subjects: [{
    type: String,
    enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam']
  }],
  salaryType: {
    type: String,
    enum: ['fixed', 'hourly'],
    required: true
  },
  salary: {
    amount: {
      type: Number,
      required: true
    },
    currency: {
      type: String,
      default: 'INR'
    }
  },
  bankingDetails: {
    accountHolderName: {
      type: String,
      required: true
    },
    accountNumber: {
      type: String,
      required: true
    },
    bankName: {
      type: String,
      required: true
    },
    ifscCode: {
      type: String,
      required: true
    },
    branchName: {
      type: String,
      required: true
    },
    aadhaarNumber: {
      type: String,
      required: true
    },
    panNumber: {
      type: String,
      required: true
    }
  },
  availableTime: {
    startTime: {
      type: String,
      required: true
    },
    endTime: {
      type: String,
      required: true
    }
  },
  availableDays: [{
    type: String,
    enum: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
  }],
  timezone: {
    type: String,
    default: 'Asia/Kolkata' // IST (Indian Standard Time) as default for all teachers
  },
  professionalInfo: {
    qualification: {
      type: String,
      default: null
    },
    specialization: {
      type: String,
      default: null
    },
    joiningDate: {
      type: Date,
      default: null
    }
  },
  assignedStudents: [{
    studentId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Student'
    },
    subject: {
      type: String,
      enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam']
    }
  }],
  isActive: {
    type: Boolean,
    default: true
  },
  isDeleted: {
    type: Boolean,
    default: false
  },
  deletedAt: {
    type: Date,
    default: null
  },
  originalPassword: {
    type: String,
    default: null
  }
}, {
  timestamps: true
});

export default mongoose.model('Teacher', teacherSchema);