const { spawn } = require('child_process');
const path = require('path');

// Define portal configurations
const portals = [
  {
    name: 'Admin Portal',
    port: 3001,
    env: { ...process.env, PORT: '3001', REACT_APP_PORTAL_TYPE: 'admin' }
  },
  {
    name: 'Teacher Portal', 
    port: 3002,
    env: { ...process.env, PORT: '3002', REACT_APP_PORTAL_TYPE: 'teacher' }
  },
  {
    name: 'Student Portal',
    port: 3003, 
    env: { ...process.env, PORT: '3003', REACT_APP_PORTAL_TYPE: 'student' }
  }
];

// Function to start a portal
function startPortal(portal) {
  
  const child = spawn('npm', ['start'], {
    cwd: path.join(__dirname, 'client'),
    env: portal.env,
    stdio: 'pipe'
  });

  child.stdout.on('data', (data) => {
  });

  child.stderr.on('data', (data) => {
    console.error(`[${portal.name}] ${data.toString().trim()}`);
  });

  child.on('close', (code) => {
  });

  return child;
}

// Start all portals

const processes = portals.map(startPortal);

// Handle graceful shutdown
process.on('SIGINT', () => {
  processes.forEach(child => {
    child.kill('SIGINT');
  });
  process.exit(0);
});

// Display portal URLs after a delay
setTimeout(() => {
  portals.forEach(portal => {
  });
}, 5000);