const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
require('dotenv').config();

async function checkAdmin() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    // Find admin user
    const adminUser = await User.findOne({ username: 'admin@edumetrix.uk' });
    if (!adminUser) {
      process.exit(0);
    }

    
    // Test password
    const passwordMatch = await bcrypt.compare('admin123', adminUser.password);
    
    process.exit(0);
  } catch (error) {
    console.error('Error checking admin:', error);
    process.exit(1);
  }
}

checkAdmin();