// Run this in browser console to completely clean all auth storage
console.log('🧹 Cleaning all authentication storage...');

// List of all possible auth keys to remove
const authKeys = [
  'token', 'user', 'isRealUser', 'is_real_user',
  'admin_token', 'admin_user', 'admin_is_real_user',
  'teacher_token', 'teacher_user', 'teacher_is_real_user', 
  'student_token', 'student_user', 'student_is_real_user'
];

let removedCount = 0;

authKeys.forEach(key => {
  if (localStorage.getItem(key)) {
    localStorage.removeItem(key);
    removedCount++;
    console.log(`✅ Removed: ${key}`);
  }
});

console.log(`🎉 Cleaned ${removedCount} authentication keys`);
console.log('📝 Current localStorage:');
for (let i = 0; i < localStorage.length; i++) {
  const key = localStorage.key(i);
  console.log(`  ${key}: ${localStorage.getItem(key)?.substring(0, 50)}...`);
}

if (localStorage.length === 0) {
  console.log('  (empty)');
}