import mongoose from 'mongoose';

const invoiceSchema = new mongoose.Schema({
  studentId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Student',
    required: true
  },
  invoiceNumber: {
    type: String,
    required: true,
    unique: true
  },
  invoiceMonth: {
    type: String,
    required: true
  },
  invoiceYear: {
    type: Number,
    required: true
  },
  classes: [{
    classId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Class'
    },
    date: {
      type: Date,
      required: true
    },
    subject: {
      type: String,
      required: true
    },
    teacher: {
      type: String,
      required: true
    },
    duration: {
      type: Number,
      required: true
    },
    rate: {
      type: Number,
      required: true
    },
    amount: {
      type: Number,
      required: true
    }
  }],
  totalClasses: {
    type: Number,
    required: true
  },
  items: [{
    description: String,
    quantity: Number,
    rate: Number,
    amount: Number
  }],
  subtotal: {
    type: Number,
    default: 0
  },
  discount: {
    type: Number,
    default: 0
  },
  discountType: {
    type: String,
    enum: ['percentage', 'fixed'],
    default: 'percentage'
  },
  tax: {
    type: Number,
    default: 0
  },
  totalAmount: {
    type: Number,
    required: true
  },
  currency: {
    type: String,
    required: true
  },
  status: {
    type: String,
    enum: ['draft', 'sent', 'paid', 'overdue'],
    default: 'draft'
  },
  enabled: {
    type: Boolean,
    default: true
  },
  dueDate: {
    type: Date,
    required: true
  },
  paidDate: {
    type: Date,
    default: null
  },
  notes: {
    type: String,
    default: ''
  },
  paymentLink: {
    type: String,
    default: ''
  },
  paymentTerms: {
    type: String,
    default: ''
  },
  bankAccountDetails: {
    accountName: String,
    accountNumber: String,
    bankName: String,
    ifscCode: String,
    sortCode: String,
    swiftCode: String,
    branchName: String,
    country: String,
    currency: String
  },
  companyDetails: {
    companyName: { type: String, default: 'EduMetrix UK' },
    address: { type: String, default: '' },
    phone: { type: String, default: '' },
    email: { type: String, default: 'contact@edumetrix.uk' },
    website: { type: String, default: 'www.edumetrix.uk' },
    registrationNumber: { type: String, default: '' }
  },
  date: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true
});

export default mongoose.model('Invoice', invoiceSchema);