import mongoose from 'mongoose';

const userSchema = new mongoose.Schema({
  username: {
    type: String,
    required: true,
    unique: true
  },
  password: {
    type: String,
    required: true
  },
  userType: {
    type: String,
    enum: ['admin', 'teacher', 'student'],
    required: true
  },
  profile: {
    
    name: {
      type: String,
      default: ''
    },
    email: {
      type: String,
      default: ''
    },
    position: {
      type: String,
      default: 'EduMetrix'
    },
    department: {
      type: String,
      default: ''
    },
    profilePicture: {
      type: String,
      default: null
    }
  },
  isActive: {
    type: Boolean,
    default: true
  },
  isDeleted: {
    type: Boolean,
    default: false
  },
  deletedAt: {
    type: Date,
    default: null
  }
}, {
  timestamps: true
});

export default mongoose.model('User', userSchema);