import mongoose from 'mongoose';

const rescheduleRequestSchema = new mongoose.Schema({
  studentId: {
    type: mongoose.Schema.Types.Mixed, // Allow both ObjectId and String for development
    ref: 'Student',
    required: true
  },
  classId: {
    type: String, // Can be ObjectId or string for mock classes
    required: true
  },
  reason: {
    type: String,
    required: true,
    trim: true
  },
  classDetails: {
    subject: {
      type: String,
      required: true
    },
    teacherName: {
      type: String,
      required: true
    },
    scheduledDate: {
      type: Date,
      required: true
    },
    duration: {
      type: Number,
      required: true,
      default: 60
    }
  },
  status: {
    type: String,
    enum: ['pending', 'approved', 'rejected'],
    default: 'pending'
  },
  adminNotes: {
    type: String,
    trim: true
  },
  processedBy: {
    type: mongoose.Schema.Types.Mixed, // Allow both ObjectId and String for development
    ref: 'User'
  },
  processedAt: {
    type: Date
  }
}, {
  timestamps: true
});

// Index for efficient queries
rescheduleRequestSchema.index({ studentId: 1, status: 1 });
rescheduleRequestSchema.index({ status: 1, createdAt: -1 });

export default mongoose.model('RescheduleRequest', rescheduleRequestSchema);