#!/bin/bash

echo "🟣 Starting Student Portal Only"
echo "==============================="

# Start backend if not running
if ! pgrep -f "node server.js" > /dev/null; then
    echo "🔧 Starting Backend Server..."
    node server.js > server.log 2>&1 &
    sleep 3
fi

# Start Student Portal
echo "🟣 Starting Student Portal (Port 3003)..."
cd client
PORT=3003 REACT_APP_PORTAL_TYPE=student npm start

# Open browser
if command -v open &> /dev/null; then
    sleep 3
    open http://localhost:3003
fi