const adminUserId = ObjectId('6895b5f8326294c45c06135b');
const studentUserId = ObjectId('6895f0cbca0f291734ba3b2a');

let chat = db.chats.findOne({
  'participants.userId': { $all: [adminUserId, studentUserId] }
});

if (\!chat) {
  const chatDoc = {
    participants: [
      { userId: adminUserId, userType: 'admin' },
      { userId: studentUserId, userType: 'student' }
    ],
    chatType: 'student-admin',
    subject: null,
    messages: [],
    isActive: true,
    lastActivity: new Date(),
    createdAt: new Date(),
    updatedAt: new Date()
  };
  const result = db.chats.insertOne(chatDoc);
  console.log('Created new chat:', result.insertedId);
} else {
  console.log('Found existing chat:', chat._id);
}

const testMessage = {
  senderId: adminUserId,
  senderType: 'admin', 
  message: 'Hello from admin\! Can the student see this message?',
  timestamp: new Date(),
  readBy: []
};

const updateResult = db.chats.updateOne(
  { _id: chat._id || ObjectId() },
  { 
    $push: { messages: testMessage },
    $set: { lastActivity: new Date(), updatedAt: new Date() }
  }
);

console.log('Message added:', updateResult.modifiedCount > 0);
EOF < /dev/null