const generatePassword = (name) => {
  const symbols = ['&', '*', '$', '#', '@'];
  const first4Letters = name.substring(0, 4).toLowerCase();
  const randomSymbol1 = symbols[Math.floor(Math.random() * symbols.length)];
  const randomSymbol2 = symbols[Math.floor(Math.random() * symbols.length)];
  const random4Digits = Math.floor(1000 + Math.random() * 9000);
  
  return `${first4Letters}${randomSymbol1}${random4Digits}${randomSymbol2}`;
};

const generateUsername = (name) => {
  const cleanName = name.toLowerCase().replace(/\s+/g, '');
  const timestamp = Date.now().toString().slice(-4); // Last 4 digits of timestamp
  const randomNum = Math.floor(Math.random() * 100).toString().padStart(2, '0'); // 2-digit random number
  return `${cleanName}${timestamp}${randomNum}@edumetrix.uk`;
};

export { generatePassword, generateUsername };